/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.process.routing.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.process.impl.ProcessImpl;
import com.cisco.pt.ipc.sim.process.routing.RoutingProcess;
import com.cisco.pt.ipc.sim.process.routing.RoutingTable;
import com.cisco.pt.ipc.sim.process.routing.StaticRoute;
import com.cisco.pt.ptmp.PacketTracerSession;

public class RoutingProcessImpl
extends ProcessImpl
implements RoutingProcess {
    public RoutingProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    public void clearAllRoutes() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("clearAllRoutes");
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public void clearRoute(IPAddress networkId, IPAddress mask) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("clearRoute");
        newCall.addIPAddressParameter(networkId);
        newCall.addIPAddressParameter(mask);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean addStaticRoute(IPAddress ipAddress, IPAddress subnetMask, IPAddress nextHop, String portName, int adminDistance) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addStaticRoute");
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(subnetMask);
        newCall.addIPAddressParameter(nextHop);
        newCall.addStringParameter(portName);
        newCall.addIntParameter(adminDistance);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: RoutingProcessImpl.addStaticRoute");
        }
        return returnMessage.getBoolValue();
    }

    public boolean removeStaticRoute(IPAddress ipAddress, IPAddress subnetMask, IPAddress nextHop, String portName, int adminDistance) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeStaticRoute");
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(subnetMask);
        newCall.addIPAddressParameter(nextHop);
        newCall.addStringParameter(portName);
        newCall.addIntParameter(adminDistance);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: RoutingProcessImpl.removeStaticRoute");
        }
        return returnMessage.getBoolValue();
    }

    public int getStaticRouteCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getStaticRouteCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: RoutingProcessImpl.getStaticRouteCount");
        }
        return returnMessage.getIntValue();
    }

    public StaticRoute getStaticRouteAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getStaticRouteAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (StaticRoute)returnMessage.getObjectValue();
    }

    public RoutingTable getRoutingTable() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getRoutingTable");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (RoutingTable)returnMessage.getObjectValue();
    }
}

